package songplayer;

public class Player {
    private PlaybackHardware hardware;
    private Song currentSong;

    public Player(PlaybackHardware hardware, Song currentSong) {
        this.hardware = hardware;
        changeSong(currentSong);
    }

    public void changeSong(Song song) {
        this.currentSong = song;
        if (hardware != null && currentSong != null) {
            hardware.play(currentSong);
        }
    }

    public void setHardware(PlaybackHardware hardware) {
        this.hardware = hardware;
        if (hardware != null && currentSong != null) {
            hardware.play(currentSong);
        }
    }

    public void stopMusic() {
        if (hardware != null) {
            hardware.stop();
        }
    }

}
