package election;

/**
 * Track political candidates and who is winning a simple election.
 * Your task: Remove as many `null` as you can!
 */
public class Main {
    public static void main(String[] args) {
        // Ensure that asserts are enabled as VM argument (-ea) by uncommenting this.
        // assert false;

        Candidate alice = new Candidate("Alice Z.", null);
        Party zen = new Party("Zen Party of Canada");
        Candidate bob = new Candidate("Bob Y.", zen);

        Riding riding = new Riding("Home Town");
        assert riding.getElectedCandidate() == null;

        riding.addCandidate(alice);
        assert riding.getElectedCandidate() == alice;

        riding.addCandidate(bob);
        assert riding.getElectedCandidate() == null;

        riding.voteFor(alice);
        assert riding.getElectedCandidate() == alice;

        riding.voteFor(bob);
        assert riding.getElectedCandidate() == null;

        riding.voteFor(bob);
        assert riding.getElectedCandidate() == bob;

        // Print summary of winner and candidates
        System.out.println("The winner in " + riding.getName() + " is " + riding.getElectedCandidate().name());
        System.out.println("All the candidates running were:");
        for (Candidate c : riding.getCandidates()) {
            System.out.printf("   %-10s with %s got %d votes.\n",
                    c.name(),
                    c.party(),
                    riding.getVotesForCandidate(c)
            );
        }

    }
}
