package c_booktitles;

import java.util.ArrayList;

/**
 * Store a collection of book titles.
 * Support the printBookList() function that is passed in a BookPrinter.
 * YOU MAY NOT EDIT THIS CLASS AT ALL.
 */
public class BookContainer {

    /**
     * Interface providing necessary support functions for this class to function:
     * - verifyNameIsNotOffensive(): Returns true if the title is not offensive.
     * - printBookTitle(): Prints the title.
     * - isBookEligibleForFreeShipping(): Returns true if the book is eligible for free shipping.
     */
    public interface BookUtil {
        boolean verifyNameIsNotOffensive(String title);
        void printBookTitle(String title);
        boolean isBookEligibleForFreeShipping(String title);
    }
    private final ArrayList<String> books = new ArrayList<>();

    public void addBook(String title) {
        books.add(title);
    }

    public void printBookList(BookUtil util) {
        for (String title : books) {
            util.printBookTitle(title);
        }
    }

    // NOTE: You can ignore this function. We don't need it for this exercise.
    public boolean areAllNamesNotOffensive(BookUtil util) {
        for (String title : books) {
            if (!util.verifyNameIsNotOffensive(title)) {
                return false;
            }
        }
        return true;
    }
    // NOTE: You can ignore this function. We don't need it for this exercise.
    public boolean areAllBooksEligibleForFreeShipping(BookUtil util) {
        for (String title : books) {
            if (!util.isBookEligibleForFreeShipping(title)) {
                return false;
            }
        }
        return true;
    }
}
