package b_factors;

public class Factor {
    public interface HandleFactor {
        void handle(int factor);
    }

    public static void forEachFactor(int number, HandleFactor handler) {
        for (int i = 1; i <= number; i++) {
            if (number % i == 0) {
                // Report the factor and then wait (pretend this takes a long time...)
                handler.handle(i);

                try {
                    Thread.sleep(100);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}
